/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.ibm.icu.text.Bidi;
import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.text.MeasuredText;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.style.MetricAffectingSpan;
import icyllis.modernui.text.style.ReplacementSpan;
import icyllis.modernui.util.Pool;
import icyllis.modernui.util.Pools;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MeasuredParagraph {
    private static final Pool<MeasuredParagraph> sPool = Pools.concurrent(1);
    @Nullable
    private Spanned mSpanned;
    private int mTextStart;
    private int mTextLength;
    private char[] mCopiedBuffer;
    private int mParaDir;
    private boolean mLtrWithoutBidi;
    @Nonnull
    private final ByteArrayList mLevels = new ByteArrayList();
    @Nonnull
    private final IntArrayList mSpanEndCache = new IntArrayList();
    @Nonnull
    private final IntArrayList mFontMetrics = new IntArrayList();
    private MeasuredText mMeasuredText;
    @Nonnull
    private final TextPaint mCachedPaint = new TextPaint();
    @Nullable
    private FontMetricsInt mCachedFm;

    private MeasuredParagraph() {
    }

    public void release() {
        this.reset();
        this.mLevels.trim();
        this.mSpanEndCache.trim();
        this.mFontMetrics.trim();
    }

    private void reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mLevels.clear();
        this.mSpanEndCache.clear();
        this.mFontMetrics.clear();
        this.mMeasuredText = null;
    }

    public int getTextLength() {
        return this.mTextLength;
    }

    @Nonnull
    public char[] getChars() {
        return this.mCopiedBuffer;
    }

    public int getParagraphDir() {
        return this.mParaDir;
    }

    @Nonnull
    public IntArrayList getSpanEndCache() {
        return this.mSpanEndCache;
    }

    @Nonnull
    public IntArrayList getFontMetrics() {
        return this.mFontMetrics;
    }

    public MeasuredText getMeasuredText() {
        return this.mMeasuredText;
    }

    @Nonnull
    private static MeasuredParagraph obtain() {
        MeasuredParagraph c = sPool.acquire();
        return c == null ? new MeasuredParagraph() : c;
    }

    @Nonnull
    public static MeasuredParagraph buildForStaticLayout(@Nonnull TextPaint paint, @Nonnull CharSequence text, int start, int end, @Nonnull TextDirectionHeuristic dir, @Nullable MeasuredParagraph recycle) {
        MeasuredParagraph c = recycle == null ? MeasuredParagraph.obtain() : recycle;
        c.resetAndAnalyzeBidi(text, start, end, dir);
        MeasuredText.Builder builder = new MeasuredText.Builder(c.mCopiedBuffer);
        if (c.mTextLength > 0) {
            if (c.mSpanned == null) {
                c.applyMetricsAffectingSpan(paint, null, start, end, builder);
                c.mSpanEndCache.add(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int spanEnd = c.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    MetricAffectingSpan[] spans = c.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, c.mSpanned, MetricAffectingSpan.class);
                    c.applyMetricsAffectingSpan(paint, spans, spanStart, spanEnd, builder);
                    c.mSpanEndCache.add(spanEnd);
                    spanStart = spanEnd;
                }
            }
            c.mMeasuredText = builder.build();
        }
        return c;
    }

    private void resetAndAnalyzeBidi(@Nonnull CharSequence text, int start, int end, @Nonnull TextDirectionHeuristic dir) {
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        this.mTextLength = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != this.mTextLength) {
            this.mCopiedBuffer = new char[this.mTextLength];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            ReplacementSpan[] spans;
            for (ReplacementSpan span : spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class)) {
                int startInPara = this.mSpanned.getSpanStart(span) - start;
                int endInPara = this.mSpanned.getSpanEnd(span) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > this.mTextLength) {
                    endInPara = this.mTextLength;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if (!(dir != TextDirectionHeuristics.LTR && dir != TextDirectionHeuristics.FIRSTSTRONG_LTR && dir != TextDirectionHeuristics.ANYRTL_LTR || Bidi.requiresBidi((char[])this.mCopiedBuffer, (int)0, (int)this.mTextLength))) {
            this.mLevels.clear();
            this.mParaDir = 0;
            this.mLtrWithoutBidi = true;
        } else {
            boolean isRtl;
            byte paraLevel = dir == TextDirectionHeuristics.LTR ? (byte)0 : (dir == TextDirectionHeuristics.RTL ? (byte)1 : (dir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? (byte)126 : (dir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? (byte)127 : ((isRtl = dir.isRtl(this.mCopiedBuffer, 0, this.mTextLength)) ? (byte)1 : 0))));
            this.mLevels.size(this.mTextLength);
            Bidi icuBidi = new Bidi(this.mTextLength, 0);
            icuBidi.setPara(this.mCopiedBuffer, paraLevel, null);
            for (int i = 0; i < this.mTextLength; ++i) {
                this.mLevels.set(i, icuBidi.getLevelAt(i));
            }
            this.mParaDir = (icuBidi.getParaLevel() & 1) == 0 ? 0 : 1;
            this.mLtrWithoutBidi = false;
        }
    }

    private void applyMetricsAffectingSpan(@Nonnull TextPaint paint, @Nullable MetricAffectingSpan[] spans, int start, int end, @Nonnull MeasuredText.Builder builder) {
        this.mCachedPaint.set(paint);
        if (this.mCachedFm == null) {
            this.mCachedFm = new FontMetricsInt();
        }
        ReplacementSpan replacement = null;
        if (spans != null) {
            for (MetricAffectingSpan span : spans) {
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateMeasureState(this.mCachedPaint);
            }
        }
        int runStart = start - this.mTextStart;
        int runEnd = end - this.mTextStart;
        this.mCachedPaint.getFontMetrics(this.mCachedFm);
        if (replacement != null) {
            this.applyReplacementRun(replacement, runStart, runEnd, builder);
        } else {
            this.applyStyleRun(runStart, runEnd, builder);
        }
        this.mFontMetrics.add(this.mCachedFm.mAscent);
        this.mFontMetrics.add(this.mCachedFm.mDescent);
    }

    private void applyReplacementRun(@Nonnull ReplacementSpan replacement, int start, int end, @Nonnull MeasuredText.Builder builder) {
        builder.addReplacementRun(this.mCachedPaint, end - start, 0.0f);
    }

    private void applyStyleRun(int start, int end, @Nonnull MeasuredText.Builder builder) {
        if (this.mLtrWithoutBidi) {
            builder.addStyleRun(this.mCachedPaint, end - start, false);
        } else {
            byte level = this.mLevels.getByte(start);
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mLevels.getByte(levelEnd) != level) {
                    boolean isRtl = (level & 1) != 0;
                    builder.addStyleRun(this.mCachedPaint, levelEnd - levelStart, isRtl);
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mLevels.getByte(levelEnd);
                }
                ++levelEnd;
            }
        }
    }

    public void recycle() {
        this.release();
        sPool.release(this);
    }
}

